/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blockentities.render;

import com.finallion.graveyard.blockentities.GravestoneBlockEntity;
import com.finallion.graveyard.blocks.GravestoneBlock;
import com.finallion.graveyard.init.TGBlocks;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GravestoneBlockEntityRenderer
extends TileEntityRenderer<GravestoneBlockEntity> {
    private static final HashMap<Block, RenderType> LAYERS = Maps.newHashMap();
    private static RenderType defaultLayer;
    private static ItemStack stack;

    public GravestoneBlockEntityRenderer(TileEntityRendererDispatcher blockEntityRenderDispatcher) {
        super(blockEntityRenderDispatcher);
    }

    public void render(GravestoneBlockEntity signBlockEntity, float f, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i, int j) {
        BlockState blockState = signBlockEntity.func_195044_w();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.25, 0.5);
        float rotation = -((Direction)blockState.func_177229_b((Property)GravestoneBlock.FACING)).func_185119_l();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.6666667f, -0.6666667f, -0.6666667f);
        matrixStack.func_227865_b_();
        FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
        matrixStack.func_227861_a_(0.0, 0.3333333432674408, 0.23);
        matrixStack.func_227862_a_(0.010416667f, -0.010416667f, 0.010416667f);
        int m = signBlockEntity.getColor().func_218388_g();
        int n = (int)((double)NativeImage.func_227791_b_((int)m) * 0.4);
        int k = (int)((double)NativeImage.func_227793_c_((int)m) * 0.4);
        int l = (int)((double)NativeImage.func_227795_d_((int)m) * 0.4);
        int i1 = NativeImage.func_227787_a_((int)0, (int)l, (int)k, (int)n);
        for (int k1 = 0; k1 < 4; ++k1) {
            IReorderingProcessor ireorderingprocessor = signBlockEntity.getRenderMessage(k1, p_243502_1_ -> {
                List list = fontrenderer.func_238425_b_((ITextProperties)p_243502_1_, 90);
                return list.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)list.get(0);
            });
            if (ireorderingprocessor == null) continue;
            float f3 = -fontrenderer.func_243245_a(ireorderingprocessor) / 2;
            fontrenderer.func_238416_a_(ireorderingprocessor, f3, (float)(k1 * 10 - 20), i1, false, matrixStack.func_227866_c_().func_227870_a_(), vertexConsumerProvider, false, 0, i);
        }
        matrixStack.func_227865_b_();
        this.renderGrave(blockState, f, matrixStack, vertexConsumerProvider, i, j);
    }

    public void renderGrave(BlockState state, float f, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i, int j) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.43, 0.5);
        matrixStack.func_227862_a_(2.28f, 2.15f, 2.28f);
        float rotation = -((Direction)state.func_177229_b((Property)GravestoneBlock.FACING)).func_185119_l();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), 1), ItemCameraTransforms.TransformType.GROUND, i, OverlayTexture.field_229196_a_, matrixStack, vertexConsumerProvider);
        matrixStack.func_227865_b_();
    }

    public static IVertexBuilder getConsumer(IRenderTypeBuffer provider, Block block) {
        return provider.getBuffer(LAYERS.getOrDefault(block, defaultLayer));
    }

    static {
        stack = new ItemStack((IItemProvider)TGBlocks.GRAVESTONE.func_199767_j(), 1);
        defaultLayer = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("textures/entity/signs/oak.png"));
        RenderType layer1 = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/polished_basalt.png"));
        RenderType layer2 = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/cobblestone.png"));
        RenderType layer3 = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/mossy_cobblestone.png"));
        RenderType layer4 = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/deepslate.png"));
        LAYERS.put(TGBlocks.GRAVESTONE, layer1);
        LAYERS.put(TGBlocks.COBBLESTONE_GRAVESTONE, layer2);
        LAYERS.put(TGBlocks.MOSSY_COBBLESTONE_GRAVESTONE, layer3);
        LAYERS.put(TGBlocks.DEEPSLATE_GRAVESTONE, layer4);
    }
}

